#ifndef _OSZIGRAPHICS_H_
#define _OSZIGRAPHICS_H_

#include <ArduinoGraphics.h>

class OsziGraphics : public ArduinoGraphics {
  uint8_t xy[1024][2];  // the display ... the dots to display
public:
  int xy_last = 0;

  OsziGraphics()
    : ArduinoGraphics(256, 256) {
      Init();
  }

  void Init();

  void dump();

  void set(int x, int y, uint8_t r, uint8_t g, uint8_t b);

  // tick must be called in loop or an isr
  // returns true if new screen starts.
  bool tick();

  void line(int x0, int y0, int x1, int y1);
};

#endif